#include <iostream>
#include <vector>
#include <iomanip>
using namespace std;

bool mogucePretecanje(vector<vector<double>>& trkaci, double vreme, int K) {
    int brojac = 0;

    for (int i = 0; i < trkaci.size(); i++) {
        double krajnjaPoz = trkaci[i][0] + vreme * trkaci[i][1];
        for (int j = i + 1; j < trkaci.size(); j++) {
            double krajnjaPozSledeceg = trkaci[j][0] + vreme * trkaci[j][1];
            if (krajnjaPoz < krajnjaPozSledeceg)
                brojac++;
        }
    }

    return brojac >= K;
}

int main() {
    int N, K;
    cin >> N >> K;

    vector<vector<double>> trkaci(N, vector<double>(2));

    for (int i = 0; i < N; i++) {
        cin >> trkaci[i][0] >> trkaci[i][1];
    }

    double pocetak = 0;
    double kraj = 1e9; // 10^9
    double rezultat = -1;

    while (kraj - pocetak > 1e-9) { // Preciznost 10^-9
        double sredina = (pocetak + kraj) / 2;

        if (mogucePretecanje(trkaci, sredina, K)) {
            rezultat = sredina;
            kraj = sredina;
        } else {
            pocetak = sredina;
        }
    }

    cout << fixed << setprecision(9) << rezultat << endl;

    return 0;
}